/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.packageconfigurationdialog;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.nooj4nlp.controller.packageconfigurationdialog.DialogStatus;
import net.nooj4nlp.controller.packageconfigurationdialog.WindowPosition;
import net.nooj4nlp.engine.Utils;
import net.nooj4nlp.engine.Zip;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class Project
implements Serializable {
    private static final long serialVersionUID = -6147896220161601998L;
    private ArrayList<Object> listOfFiles;
    private transient ArrayList<JInternalFrame> listOfForms = new ArrayList();

    public static Project load(String prjdir) {
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        Project prj = null;
        try {
            fis = new FileInputStream(FilenameUtils.concat(prjdir, "project.xml"));
            ois = new ObjectInputStream(fis);
            prj = (Project)ois.readObject();
            fis.close();
        }
        catch (FileNotFoundException e) {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream!", 0);
        }
        catch (IOException e) {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
        }
        catch (ClassNotFoundException e) {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot load file ", "NooJ Error!", 0);
        }
        prj.listOfForms = new ArrayList();
        return prj;
    }

    public void save(JTable table, JTextPane rtbText, String projname, String docdir, ArrayList<Object> languagesResourcesLex, ArrayList<Object> languagesResourcesSyn) {
        File f2;
        File f1;
        String tname;
        String sname;
        String sdirname;
        int priority;
        Object fname;
        boolean found;
        String lname2;
        int ilr;
        String prjdir = projname + "_dir";
        File f = new File(prjdir);
        if (!f.exists()) {
            f.mkdir();
        }
        ArrayList<String> languages = new ArrayList<String>();
        for (ilr = 0; ilr < languagesResourcesLex.size(); ilr += 3) {
            lname2 = (String)languagesResourcesLex.get(ilr);
            found = false;
            for (String l : languages) {
                if (!l.equalsIgnoreCase(lname2)) continue;
                found = true;
                break;
            }
            if (!found) {
                languages.add(lname2);
            }
            fname = (String)languagesResourcesLex.get(ilr + 1);
            priority = (Integer)languagesResourcesLex.get(ilr + 2);
            sdirname = FilenameUtils.concat(docdir, FilenameUtils.concat(lname2, "Lexical Analysis"));
            sname = FilenameUtils.concat(sdirname, (String)fname);
            tname = null;
            tname = priority < 0 ? FilenameUtils.concat(prjdir, "-" + lname2 + "-LA-" + String.format("%1d", priority) + (String)fname) : FilenameUtils.concat(prjdir, "-" + lname2 + "-LA-" + String.format("%02d", priority) + (String)fname);
            f1 = new File(sname);
            f2 = new File(tname);
            if (!f1.exists() || f2.exists()) continue;
            try {
                FileUtils.copyFile(f1, f2);
                continue;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            }
        }
        for (ilr = 0; ilr < languagesResourcesSyn.size(); ilr += 3) {
            lname2 = (String)languagesResourcesSyn.get(ilr);
            found = false;
            for (String l : languages) {
                if (!l.equalsIgnoreCase(lname2)) continue;
                found = true;
                break;
            }
            if (!found) {
                languages.add(lname2);
            }
            fname = (String)languagesResourcesSyn.get(ilr + 1);
            priority = (Integer)languagesResourcesSyn.get(ilr + 2);
            sdirname = FilenameUtils.concat(docdir, FilenameUtils.concat(lname2, "Syntactic Analysis"));
            sname = FilenameUtils.concat(sdirname, (String)fname);
            tname = null;
            tname = FilenameUtils.concat(prjdir, "-" + lname2 + "-SA-" + String.format("%02d", priority) + (String)fname);
            f1 = new File(sname);
            f2 = new File(tname);
            if (!f1.exists() || f2.exists()) continue;
            try {
                FileUtils.copyFile(f1, f2);
                continue;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            }
        }
        for (String lname2 : languages) {
            String sdirname2 = FilenameUtils.concat(docdir, FilenameUtils.concat(lname2, "Lexical Analysis"));
            String sname2 = FilenameUtils.concat(sdirname2, "_properties.def");
            String tname2 = FilenameUtils.concat(prjdir, "-" + lname2 + "-" + "_properties.def");
            File f12 = new File(sname2);
            File f22 = new File(tname2);
            if (!f12.exists() || f22.exists()) continue;
            try {
                FileUtils.copyFile(f12, f22);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            }
        }
        StyledDocument doc = (StyledDocument)rtbText.getDocument();
        HTMLEditorKit kit = new HTMLEditorKit();
        String rtfFilePath = FilenameUtils.concat(prjdir, "ReadMe.rtf");
        BufferedWriter writer = null;
        try {
            File rtfFile = new File(rtfFilePath);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(rtfFile));
            writer = new BufferedWriter(outputStreamWriter);
            kit.write(outputStreamWriter, (Document)doc, 0, doc.getLength());
            writer.close();
        }
        catch (FileNotFoundException e1) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException outputStreamWriter) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot write to file " + rtfFilePath, "ONooJ", 0);
            return;
        }
        catch (IOException e1) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException outputStreamWriter) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot write to file " + rtfFilePath, "ONooJ", 0);
            return;
        }
        catch (BadLocationException e) {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException outputStreamWriter) {
                // empty catch block
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot write to file " + rtfFilePath, "ONooJ", 0);
            return;
        }
        this.listOfFiles = new ArrayList();
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            String type = (String)model.getValueAt(i, 0);
            if (type.equals("Locate")) {
                DialogStatus ds = (DialogStatus)model.getValueAt(i, 3);
                this.listOfFiles.add(type);
                this.listOfFiles.add("");
                this.listOfFiles.add(ds);
                continue;
            }
            String fName = (String)model.getValueAt(i, 1);
            String dName = (String)model.getValueAt(i, 2);
            WindowPosition wp = (WindowPosition)model.getValueAt(i, 3);
            this.listOfFiles.add(type);
            this.listOfFiles.add(fName);
            this.listOfFiles.add(wp);
            String fullName = FilenameUtils.concat(dName, fName);
            String resName = FilenameUtils.concat(prjdir, fName);
            if (fullName.equals(resName)) continue;
            File src = new File(fullName);
            if (!src.exists()) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), "Cannot find file " + fullName, "ONooJ", 0);
                return;
            }
            File dest = new File(resName);
            try {
                FileUtils.copyFile(src, dest);
                continue;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            }
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(FilenameUtils.concat(prjdir, "project.xml"));
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this);
            oos.flush();
            fos.close();
        }
        catch (IOException e) {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e1) {
                System.out.println("erreur");
            }
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            return;
        }
        File projDir = new File(projname);
        if (projDir.exists()) {
            Utils.deleteDir(projDir);
        }
        try {
            Zip.compressDir(prjdir, projname);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(Launcher.getDesktopPane(), e.getMessage(), "Error while getting file stream! Input-output error!", 0);
            return;
        }
    }

    public ArrayList<Object> getListOfFiles() {
        return this.listOfFiles;
    }

    public ArrayList<JInternalFrame> getListOfForms() {
        return this.listOfForms;
    }

    public void setListOfForms(ArrayList<JInternalFrame> listOfForms) {
        this.listOfForms = listOfForms;
    }
}

